unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  UKlasy;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    btncLOSE: TBitBtn;
    btnSTART: TBitBtn;
    Timer1: TTimer;
    Timer2: TTimer;
    Timer3: TTimer;
    Timer4: TTimer;
    procedure btnSTARTClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Timer4Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure btncLOSEClick(Sender: TObject);

  private

  public
	 kwadrat   : MFigura;
    prostokat : MFigura;
    kolo      : MFigura;
    elipsa    : MFigura;
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.btncLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
begin
	if Assigned(kolo) then
   begin
	   kolo.Move();
   end;
end;

procedure TMainForm.Timer2Timer(Sender: TObject);
begin
	if Assigned(kwadrat) then
   begin
	   kwadrat.Move();
   end;
end;

procedure TMainForm.Timer3Timer(Sender: TObject);
begin
	if Assigned(prostokat) then
   begin
	   prostokat.Move();
   end;
end;

procedure TMainForm.Timer4Timer(Sender: TObject);
begin
	if Assigned(elipsa) then
   begin
	   elipsa.Move();
   end;
end;

procedure TMainForm.btnSTARTClick(Sender: TObject);
begin
   Timer1.Enabled := true;
   Timer2.Enabled := true;
   Timer3.Enabled := true;
   Timer4.Enabled := true;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Timer1.Enabled := false;
   Timer2.Enabled := false;
   Timer3.Enabled := false;
   Timer4.Enabled := false;
   
   if Assigned(kwadrat) then
   begin
		FreeAndNil(kwadrat);
   end;

   if Assigned(kolo) then
   begin
		FreeAndNil(kolo);
   end;

   if Assigned(prostokat) then
   begin
		FreeAndNil(prostokat);
   end;

   if Assigned(elipsa) then
   begin
		FreeAndNil(elipsa);
   end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   kwadrat                := MFigura.Create(MainForm);
   kwadrat.Parent         := MainForm;
   kwadrat.Shape          := stSquare;
   kwadrat.Brush.Color    := clSilver;
   kwadrat.Top            := 80;
   kwadrat.Left           := 60;
   kwadrat.Height         := 35;
   kwadrat.w_gore         := true;

	kolo                   := MFigura.Create(MainForm);
	kolo.Parent            := MainForm;
   kolo.Shape             := stCircle;
   kolo.Brush.Color       := clMoneyGreen;
   kolo.Top               := 130;
   kwadrat.Left           := 80;
   kolo.Height            := 35;
   kolo.w_gore            := false;

   prostokat              := MFigura.Create(MainForm);
	prostokat.Parent       := MainForm;
   prostokat.Shape        := stRectangle;
   prostokat.Brush.Color  := clInfoBk;
   prostokat.Top          := 200;
   prostokat.Left         := 90;
   prostokat.Height       := 35;
   prostokat.w_gore       := true;

	elipsa                 := MFigura.Create(MainForm);
	elipsa.Parent          := MainForm;
   elipsa.Shape           := stEllipse;
   elipsa.Brush.Color     := clSkyBlue; //clRed;
   elipsa.Top             := 270;
   elipsa.Left            := 150;
   elipsa.Height          := 35;
   elipsa.Width           := 65;
   elipsa.w_gore          := false;
end;


end.

